#include <iostream>
using namespace std;

// تابع بازگشتی برای یافتن بزرگترین عدد با روش تقسیم و حل
int findMax(int arr[], int low, int high) {
    // شرط پایان: اگر تنها یک عنصر باشد، آن عدد را برمی‌گردانیم
    if (low == high)
        return arr[low];

    // تقسیم آرایه به دو نیمه
    int mid = low + (high - low) / 2;

    // بازگشتی برای یافتن بزرگترین عدد در هر نیمه
    int maxLeft = findMax(arr, low, mid);
    int maxRight = findMax(arr, mid + 1, high);

    // مقایسه بزرگترین عناصر دو نیمه و برمی‌گردانیم
    return (maxLeft > maxRight) ? maxLeft : maxRight;
}

int main() {
    int n;
    cout << "Enter the number of elements (n): ";
    cin >> n;

    // آرایه را از ورودی خوانده و ذخیره می‌کنیم
    int* arr = new int[n];
    cout << "Enter " << n << " elements:\n";
    for (int i = 0; i < n; i++) {
        cin >> arr[i];
    }

    // اگر آرایه خالی است، پیام خطا نمایش می‌دهیم
    if (n == 0) {
        cout << "The array is empty." << endl;
        return 0;
    }

    // یافتن بزرگترین عدد با روش تقسیم و حل
    int maxElement = findMax(arr, 0, n - 1);

    // چاپ نتیجه
    cout << "The maximum element is: " << maxElement << endl;

    // حافظه را آزاد می‌کنیم
    delete[] arr;
    return 0;
}
