#include <iostream>
#include <vector>
#include <limits> // برای استفاده از infinity

using namespace std;

const int INF = numeric_limits<int>::max(); // تعیین مقدار بی‌نهایت

int main() {
    int n;
    cout << "Enter the number of vertices (n): ";
    cin >> n;

    // خواندن ماتریس وزن‌ها (W)
    vector<vector<int>> W(n, vector<int>(n, INF));
    cout << "Enter the adjacency matrix (use 'INF' for no edge):\n";
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (i == j) {
                W[i][j] = 0; // قطر اصلی برابر صفر است
            } else {
                int weight;
                cin >> weight;
                W[i][j] = weight;
            }
        }
    }

    // اجرای الگوریتم فلوید-沃셜
    vector<vector<int>> D = W; // ماتریس D را ابتدا برابر W قرار می‌دهیم
    for (int k = 0; k < n; k++) { // k: رأس میانی
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                // اگر اضافه کردن رأس k مسیر کوتاه‌تری ایجاد کند، ماتریس را به‌روز می‌کنیم
                if (D[i][k] != INF && D[k][j] != INF && D[i][k] + D[k][j] < D[i][j]) {
                    D[i][j] = D[i][k] + D[k][j];
                }
            }
        }
    }

    // چاپ ماتریس نهایی (D)
    cout << "\nThe shortest path distances between all pairs of vertices:\n";
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (D[i][j] == INF) {
                cout << "INF\t";
            } else {
                cout << D[i][j] << "\t";
            }
        }
        cout << endl;
    }

    return 0;
}
