#include <iostream>
#include <vector>
#include <algorithm> // برای استفاده از sort

using namespace std;

// ساختار برای ذخیره اطلاعات هر کار
struct Job {
    int id;       // شناسه کار
    int duration; // زمان اجرای کار (p_i)
    int deadline; // زمان معین (d_i)
    int start;    // زمان شروع (s_i)
    int finish;   // زمان پایان (f_i)
    int delay;    // تاخیر (t_i)
};

// مقایسه کارها بر اساس زمان معین (صعودی)
bool compareJobs(const Job& a, const Job& b) {
    return a.deadline < b.deadline;
}

int main() {
    int n;
    cout << "Enter the number of jobs: ";
    cin >> n;

    // آرایه برای ذخیره اطلاعات کارها
    vector<Job> jobs(n);

    // خواندن اطلاعات کارها
    for (int i = 0; i < n; i++) {
        jobs[i].id = i + 1;
        cout << "Enter duration and deadline for job " << i + 1 << ": ";
        cin >> jobs[i].duration >> jobs[i].deadline;
    }

    // مرتب‌سازی کارها بر اساس زمان معین (صعودی)
    sort(jobs.begin(), jobs.end(), compareJobs);

    // زمان شروع اولین کار
    jobs[0].start = 0;
    jobs[0].finish = jobs[0].start + jobs[0].duration;
    jobs[0].delay = max(0, jobs[0].finish - jobs[0].deadline);

    // محاسبه زمان‌بندی برای کارهای بعدی
    for (int i = 1; i < n; i++) {
        jobs[i].start = jobs[i - 1].finish; // زمان شروع کار فعلی برابر زمان پایان کار قبلی است
        jobs[i].finish = jobs[i].start + jobs[i].duration;
        jobs[i].delay = max(0, jobs[i].finish - jobs[i].deadline);
    }

    // چاپ نتایج
    cout << "\nJob Scheduling Results:\n";
    cout << "ID\tDuration\tDeadline\tStart\tFinish\tDelay\n";
    for (const auto& job : jobs) {
        cout << job.id << "\t" << job.duration << "\t\t" << job.deadline << "\t\t"
             << job.start << "\t" << job.finish << "\t" << job.delay << endl;
    }

    return 0;
}
